<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User;

use Erlage\Photogram\Data\Models\AbstractModel;
use Erlage\Photogram\Data\Tables\User\UserTable;

final class UserModel extends AbstractModel implements InterfaceUserGetter
{
    /**
     * getter interface
     */
    use TraitUserGetters;

    /*
    |--------------------------------------------------------------------------
    | reflection related
    |--------------------------------------------------------------------------
    */

    public function getTableClassName(): string
    {
        return UserTable::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | override the delete logic
    |--------------------------------------------------------------------------
    */

    public function delete(): bool
    {
        UserModelHelper::deleteDependencies($this);

        return parent::delete();
    }

    /*
    |--------------------------------------------------------------------------
    | helper methods
    |--------------------------------------------------------------------------
    */

    public function isPrivate(): bool
    {
        return UserEnum::META_IS_PRIVATE_YES == $this -> getMetaIsPrivate();
    }

    public function isEmailVerified(): bool
    {
        return UserEnum::META_IS_EMAIL_VERIFIED_YES == $this -> getMetaIsEmailVerified();
    }
}
